import ij.*;
import ij.process.*;
import ij.gui.*;
import java.awt.*;
import ij.plugin.filter.*;

public class BuildStackForTest_ implements PlugInFilter {
    ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return DOES_ALL;
    }

    public void run(ImageProcessor ip) {

        short[] pixels;

        int width = ip.getWidth();
        Rectangle r = ip.getRoi();
        byte a;
        int offset, i,j;
        int nFrames = imp.getStackSize();

        double px=30;
        double py=30;

        double px2 = 100;
        double py2 = 60;

        double vx =1.23456;
        double vy=2.3456;

        double vx2 = -1;
        double vy2 = 1;
        double c,c2;
        double s,s2;

        for (int Slice=1;Slice<=nFrames; Slice++) {
            imp.setSlice(Slice);
            pixels = (short[])ip.getPixels();
            for (int y=r.y; y<(r.y+r.height); y++) {
                offset = y*width;
                for (int x=r.x; x<(r.x+r.width); x++) {
                    i = offset + x;
                    s2 = (x-px)*(x-px)+(y-py)*(y-py);
                    s = (x-px2)*(x-px2)+(y-py2)*(y-py2);
                    c = Math.exp(-s2/3);
                    c2 = Math.exp(-s/6);
                    pixels[i]=(short)( 25400.0 * ( c + c2) );
                } // for x
            } // for y	
            px += vx;
            py += vy;
            if (py >80) vy = -vy;
            px2 += vx2;
            py2 += vy2;
            if (py2 >80) vy2 = -vy2;
        } // for Slice
    }
}
