import ij.*;
import ij.process.*;
import ij.gui.*;
import java.awt.*;
import java.lang.*;
import ij.plugin.filter.*;
import ij.text.*;
import ij.plugin.frame.*;
import ij.measure.*;
import ij.util.*;

public class DrawCentri_ implements PlugInFilter {
    ImagePlus imp;
    private ResultsTable rt;
    private int objectSize = 5;
    private int tabSize = objectSize*2+1;
    private int correlSize = 5;
    private int tab[][][];
    private double posX[],posY[];
    private ImageProcessor theIP;
    private String st;	
    private double mat[][];
    private double temp[];

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        if (arg.equals("about"))
            {showAbout(); return DONE;}
        return DOES_ALL;
        }  // public int setup(String arg, ImagePlus imp)

    public void run(ImageProcessor ip) {

        int tmp1,tmp2;
        ImageStack is;

        ExRoi r = new ExRoi(imp);
        imp.setRoi(r);
        imp.draw();

    } // public void run(ImageProcessor ip)

    void showAbout() {
        IJ.showMessage("About DrawCentri_...",
            "Ce PlugIn sert � afficher les diff�rentes\n" +
            "position des centrioles."
        );
    }

} // public class DrawCentri_ implements PlugInFilterv

class ExRoi extends Roi {

    private double ox[][],oy[][];
    private int nFrames, nObjects;
    private ImagePlus imp;
    private ImageStack is;	
    private String st;
    private String strs [];
    private int tmp1, tmp2;
    private int pos, lpos,cc;
    private String stro;

    private int lx,ly;
    private	final int pe=1;
    private	final int gr=3;
    private Graphics g;

    // constructeur de la classe qui r�cup�re les informations � partir 
    // du label de chacune des Slices de la Stack

public ExRoi(ImagePlus imp) {
    super(0,0,imp.getWidth(),imp.getHeight(), null);

    this.imp=imp;
    this.is = imp.getStack();

    this.nFrames=is.getSize();

    ox  = new  double [nFrames+1][]; 
    oy  = new  double [nFrames+1][];

    for(int j=1;j<=nFrames;j++){
        st = is.getSliceLabel(j);
        if (st == null) st="";
            tmp1 = st.indexOf("<track\t");
            if (tmp1 != -1) {
                tmp2 = st.indexOf("track>");
                st = st.substring(tmp1 + 7,tmp2);
            } // if

            cc = 0;
            pos = -1;
            while ( (pos = st.indexOf("\t",pos+1)) != -1) {
                cc++;
            }

            nObjects = cc/2;
            ox[j]= new double [ nObjects];
            oy[j]= new double [ nObjects];

            lpos =0; pos = -1;
            int i=0;
            while ( (pos = st.indexOf("\t",lpos)) != -1)  {
            stro = st.substring(lpos,pos);
                ox[j][i] = Tools.parseDouble(stro);
                lpos = pos+1;
                pos = st.indexOf("\t",lpos);
                stro = st.substring(lpos,pos);
                oy[j][i] = Tools.parseDouble(stro);
                lpos = pos +1;
                i++;
            } // while
        } // for j
    } // fin du constructeur  public ExRoi(ImagePlus imp)

private int myscreenX(double x){
        return  (int)Math.round((x+0.5-ic.getSrcRect().x)*ic.getMagnification());
} // private int myscreenX(double x)
private int myscreenY(double y){
        return  (int)Math.round((y+0.5-ic.getSrcRect().y)*ic.getMagnification());
} //  private int myscreenY(double y)

    private void croix(double x, double y){
        int sx = myscreenX(x);
        int sy = myscreenY(y);
        g.drawLine(sx-2, sy, sx+2, sy);
        g.drawLine(sx, sy-2, sx, sy+2);
    }

    private void start(int x,int y){
        lx=x;
        ly=y;
    }
    private void left(){
        g.drawLine(lx,ly,lx-=gr,ly);
    }
    private void right(){
        g.drawLine(lx,ly,lx+=gr,ly);
    }
    private void up(){
        g.drawLine(lx,ly,lx,ly-=gr);
    }
    private void down(){
        g.drawLine(lx,ly,lx,ly+=gr);
    }

    private void croixouverte(double x, double y){
        int sx = myscreenX(x);
        int sy = myscreenY(y);

        start(sx-pe,sy-pe);
        up();
        right();
        down();
        right();
        down();
        left();
        down();
        left();
        up();
        left();
        up();
        right();
    }

    public void draw(Graphics g) {
    this.g =g;
    for(int j=1;j<=nFrames;j++){
    for(int i=0;i<nObjects;i++){
                if (imp.getCurrentSlice() == j) { 
                    g.setColor(new Color(0,0,255));
            croixouverte(ox[j][i],oy[j][i]);
        } else { 
                    if (!IJ.altKeyDown()) {
                        g.setColor(new Color(0,255,0));
                croix(ox[j][i],oy[j][i]);
            } // if
        } // if 
    } // for i
    } // for j
    } // public void draw(Graphics g)
} // class ExRoi extends Roi
