import ij.*;
import ij.process.*;
import ij.gui.*;
import java.awt.*;
import java.lang.*;
import ij.plugin.filter.*;
import ij.text.*;
import ij.plugin.frame.*;
import ij.measure.*;
import ij.util.*;

public class DrawQuadrupole_ implements PlugInFilter {
    ImagePlus imp;
    private ResultsTable rt;
    private int objectSize = 5;
    private int tabSize = objectSize*2+1;
    private int correlSize = 5;
    private int tab[][][];
    private double posX[],posY[];

    private double vitX[],vitY[];
    private ImageProcessor theIP;
    private String st;	
    private double mat[][];
    private double temp[];

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        if (arg.equals("about"))
            {showAbout(); return DONE;}
        return DOES_ALL;
        }  // public int setup(String arg, ImagePlus imp)

    public void run(ImageProcessor ip) {

        int tmp1,tmp2;
        ImageStack is;

        ExRoi r = new ExRoi(imp);
        imp.setRoi(r);
        imp.draw();

    } // public void run(ImageProcessor ip)

    void showAbout() {
        IJ.showMessage("About DrawCentri_...",
            "Ce PlugIn sert   afficher les diff rentes\n" +
            "position des centrioles."
        );
    }

} // public class DrawQuadrupole_ implements PlugInFilterv

class ExRoi extends Roi {

    private double ox[][],oy[][];
    private double vx[][],vy[][];
    private int nFrames, nObjects;
    private ImagePlus imp;
    private ImageStack is;	
    private String st;
    private String strs [];
    private int tmp1, tmp2;
    private int pos, lpos,cc;
    private String stro;

    private int lx,ly;
    private	final int pe=1;
    private	final int gr=3;
    private Graphics g;

    // constructeur de la classe qui r cup re les informations   partir 
    // du label de chacune des Slices de la Stack

public ExRoi(ImagePlus imp) {
    super(0,0,imp.getWidth(),imp.getHeight(), null);

    this.imp=imp;
    this.is = imp.getStack();

    this.nFrames=is.getSize();

    ox  = new  double [nFrames+1][]; 
    oy  = new  double [nFrames+1][];

    for(int j=1;j<=nFrames;j++){
        st = is.getSliceLabel(j);
        if (st == null) st="";
            tmp1 = st.indexOf("<track\t");
            if (tmp1 != -1) {
                tmp2 = st.indexOf("track>");
                st = st.substring(tmp1 + 7,tmp2);
            } // if

            cc = 0;
            pos = -1;
            while ( (pos = st.indexOf("\t",pos+1)) != -1) {
                cc++;
            }

            nObjects = cc/2;
            ox[j]= new double [ nObjects];
            oy[j]= new double [ nObjects];

            lpos =0; pos = -1;
            int i=0;
            while ( (pos = st.indexOf("\t",lpos)) != -1)  {
            stro = st.substring(lpos,pos);
                ox[j][i] = Tools.parseDouble(stro);
                lpos = pos+1;
                pos = st.indexOf("\t",lpos);
                stro = st.substring(lpos,pos);
                oy[j][i] = Tools.parseDouble(stro);
                lpos = pos +1;
                i++;
            } // while
        } // for j
    } // fin du constructeur  public ExRoi(ImagePlus imp)

private int myscreenX(double x){
        return  (int)Math.round((x+0.5-ic.getSrcRect().x)*ic.getMagnification());
} // private int myscreenX(double x)

private int myscreenY(double y){
        return  (int)Math.round((y+0.5-ic.getSrcRect().y)*ic.getMagnification());
} //  private int myscreenY(double y)

    private void croix(double x, double y){
        int sx = myscreenX(x);
        int sy = myscreenY(y);
        g.drawLine(sx-2, sy, sx+2, sy);
        g.drawLine(sx, sy-2, sx, sy+2);
    }

    private void carre(double x, double y){
        int sx = myscreenX(x);
        int sy = myscreenY(y);
        g.drawLine(sx-1, sy-1, sx+1, sy-1);
        g.drawLine(sx-1, sy+1, sx+1, sy+1);

        g.drawLine(sx-1, sy-1, sx-1, sy+1);
        g.drawLine(sx+1, sy-1, sx+1, sy+1);
    }

 private void fleche(double x, double y, double vx, double vy){
        int sx = myscreenX(x);
        int sy = myscreenY(y);
        int svx =(int)Math.round(vx);
        int svy =(int)Math.round(vy);

        g.drawLine(sx,sy, sx+svx, sy+svy);

if(svy<=10){
        g.drawLine(sx,sy-1, sx+svx, sy+svy-1);
        g.drawLine(sx,sy+1, sx+svx, sy+svy+1);}

if(svx<=10){g.drawLine(sx-1,sy, sx-1+svx, sy+svy);
        g.drawLine(sx+1,sy, sx+1+svx, sy+svy);}

    }


    private void start(int x,int y){
        lx=x;
        ly=y;
    }
    private void left(){
        g.drawLine(lx,ly,lx-=gr,ly);
    }
    private void right(){
        g.drawLine(lx,ly,lx+=gr,ly);
    }
    private void up(){
        g.drawLine(lx,ly,lx,ly-=gr);
    }
    private void down(){
        g.drawLine(lx,ly,lx,ly+=gr);
    }

    private void croixouverte(double x, double y){
        int sx = myscreenX(x);
        int sy = myscreenY(y);

        start(sx-pe,sy-pe);
        up();
        right();
        down();
        right();
        down();
        left();
        down();
        left();
        up();
        left();
        up();
        right();
    }

    public void draw(Graphics g) {
    
   int couleur=0;
   int tailleligne=1;
   double ux=0;
   double uy=0;
   double ux1=0;
   double uy1=0;
double   vux1=0;
double vuy1=0;
double corx1=0;
double ox1=0;
double oy1=0;
double Orx1=0;
double Ory1=0;



   this.g =g;
   couleur=255;
   
 for(int j=1;j<=nFrames-1;j++){
    for(int i=1;i<nObjects;i++){
                if (imp.getCurrentSlice() == 1) { 
                    g.setColor(new Color(0,0,255));
                    croixouverte(ox[1][i],oy[1][i]);
                   
                                                 } else { 
   
//couleur=(int)Math.round(50*(ox[nFrames-1][i]-ox[1][i]));

//couleur=(int)Math.round(ox[nFrames-1][i]);

//couleur=(int)(100+100*i);

//couleur=(int)Math.round(Math.abs(5* (oy[nFrames-1][i]-oy[1][i]) )) % 255;


//Bonjour Abdoulaye

//j'ai pupitr les lignes pour la divergence et le rotationnel, pour une grille
//comportant 384 lignes
//je les ai mis en commentaires, il suffit d'enlever le slash et l'toile qui
//encadrent les zones en commentaire. Le rsultat est intressant dites moi ce que a vous inspire
//ah oui : faut aussi complter la grille vers le centre

//module des vitesses

/*couleur=(int)Math.round
(Math.abs(Math.sqrt(10000*
       (
         (oy[nFrames][i]-oy[1][i])*(oy[nFrames][i]-oy[1][i])+
         (ox[nFrames][i]-ox[1][i])*(ox[nFrames][i]-ox[1][i])
        ) 
                    )
         )
 ) % 255;*/

//divergence du champ de vitesse: 


/*couleur=((int)Math.round
(305*( ( (oy[nFrames][i+tailleligne]-oy[1][i+tailleligne])-(oy[nFrames][i-tailleligne]-oy[1][i-tailleligne]) )
               
                  +(ox[nFrames][i+1]-ox[1][i+1]-(ox[nFrames][i-1]-ox[1][i-1]) )  
                )
                ) 

                
                )% 255;
*/




//rotationnel du champ de vitesse (module du vecteur tourbillon align suivant Oz):

/* couleur=((int)Math.round

(Math.abs(200*(  ((ox[nFrames][i-tailleligne]-ox[1][i-tailleligne])-(ox[nFrames][i+tailleligne]-ox[1][i+tailleligne])  )
                 -((oy[nFrames][i+1]-oy[1][i+1])-(oy[nFrames][i-1]-oy[1][i-1]                                        )  )                       
               ) 
          ) 
 ) 
 ) % 255;*/


/*couleur=(int)Math.round
(Math.abs(Math.sqrt(3000*
       (
         (oy[nFrames][i]-oy[1][i])*(oy[nFrames][i]-oy[1][i])
         +(ox[nFrames][i]-ox[1][i])*(ox[nFrames][i]-ox[1][i])
         
        ) 
                    )
         )
 ) % 255;*/
                
couleur=255;

/* trac des tracks*/

           if (!IJ.altKeyDown()) {
             
              if(couleur<0)
               {
                g.setColor(new Color(0,couleur,0));
                croix(ox[j][i],oy[j][i]);
                }

               if(couleur>0)
               {
                g.setColor(new Color(0,0,Math.abs(couleur)));
                croixouverte(ox[1][i],oy[1][i]);
                }}

/*trac des vecteurs tangents*/



if (!IJ.altKeyDown()) {
                uy1=oy[nFrames][i]-oy[1][i];

                ux1=ox[nFrames][i]-ox[1][i];

                vx1=ox[1][i]-405;
                vy1=oy[1][i]-307;

                vux1=vx1/Math.sqrt((vx1*vx1+vy1*vy1));
                vuy1=vy1/Math.sqrt((vx1*vx1+vy1*vy1)); 

                Orx1=-vuy1;
		Ory1=vux1;
                
                ux=10*ux1/Math.sqrt((ux1*ux1+uy1*uy1)); 
                uy=10*uy1/Math.sqrt((ux1*ux1+uy1*uy1)); 

                corx1=Orx1*ux+Ory1*uy;

                ox1=corx1*Orx1;
                oy1=corx1*Ory1;


if ((ux*ux+uy*uy)<10000000)

              {  g.setColor(new Color(0,couleur,0));
                
                fleche(ox[1][i],oy[1][i],ox1,oy1);}

                }



            
 // if
        } // if 
    } // for i
    } // for j
    } // public void draw(Graphics g)
} // class ExRoi extends Roi

