package plugins.tracker.exroi;
import ij.*;
import ij.process.*;
import ij.gui.*;
import java.awt.*;
import java.lang.*;
import ij.plugin.filter.*;
import ij.text.*;
import ij.plugin.frame.*;
import ij.measure.*;
import ij.util.*;

public class ExRoi extends Roi {

    private double ox[][],oy[][];
    private int nFrames, nObjects;
    private ImagePlus imp;
    private ImageStack is;	
    private String st;
    private String strs [];
    private int tmp1, tmp2;
    private int pos, lpos,cc;
    private String stro;

    // constructeur de la classe qui r�cup�re les informations � partir 
    // du label de chacune des Slices de la Stack

    public ExRoi(ImagePlus imp) {
        super(0,0,imp.getWidth(),imp.getHeight(), null);

        this.imp=imp;
        this.is = imp.getStack();

        this.nFrames=is.getSize();

        ox  = new  double [nFrames+1][]; 
        oy  = new  double [nFrames+1][];

        for(int j=1;j<=nFrames;j++){
            st = is.getSliceLabel(j);
            if (st == null) st="";
            tmp1 = st.indexOf("<track\t");
            if (tmp1 != -1) {
                tmp2 = st.indexOf("track>");
                st = st.substring(tmp1 + 7,tmp2);
            } // if

            cc = 0;
            pos = -1;
            while ( (pos = st.indexOf("\t",pos+1)) != -1) {
                cc++;
            }

            nObjects = cc/2;
            ox[j]= new double [ nObjects];
            oy[j]= new double [ nObjects];

            lpos =0; pos = -1;
            int i=0;
            while ( (pos = st.indexOf("\t",lpos)) != -1)  {
                stro = st.substring(lpos,pos);
                ox[j][i] = Tools.parseDouble(stro);
                lpos = pos+1;
                pos = st.indexOf("\t",lpos);
                stro = st.substring(lpos,pos);
                oy[j][i] = Tools.parseDouble(stro);
                lpos = pos +1;
                i++;
            } // while
        } // for j
    } // fin du constructeur  public ExRoi(ImagePlus imp)

    private int myscreenX(double x){
        return  (int)Math.round((x-ic.getSrcRect().x)*ic.getMagnification());
    } // private int myscreenX(double x)
    private int myscreenY(double y){
        return  (int)Math.round((y-ic.getSrcRect().y)*ic.getMagnification());
    } //  private int myscreenY(double y)

    private void croix(double x, double y, Graphics g){
        int sx1 = myscreenX(x)-2;
        int sy1 = myscreenY(y)-2;
        g.drawRect(sx1, sy1, 5, 5);
    }

    public void draw(Graphics g) {
        for(int j=1;j<=nFrames;j++){
             for(int i=0;i<nObjects;i++){
                if (imp.getCurrentSlice() == j) 
                    g.setColor(new Color(0,0,255));
                else 
                    g.setColor(new Color(0,255,0));
                croix(ox[j][i],oy[j][i],g);
            } // for i
        } // for j
    } // public void draw(Graphics g)
} // class ExRoi extends Roi
