import ij.*;
import ij.process.*;
import ij.gui.*;
import java.awt.*;
import java.lang.*;
import ij.plugin.filter.*;
import ij.text.*;
import ij.plugin.frame.*;
import ij.measure.*;
import ij.util.*;

public class TextCentri_ implements PlugInFilter {
    ImagePlus imp;
    private ResultsTable rt;
    private ImageProcessor theIP;
    private String st;	


    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        if (arg.equals("about"))
            {showAbout(); return DONE;}
        return DOES_ALL;
        }  // public int setup(String arg, ImagePlus imp)

    public void run(ImageProcessor ip) {

        int tmp1,tmp2;
        ImageStack is;


        is = imp.getStack();
        int nFrames=is.getSize();

        String titre = "Frame"; 
        st = is.getSliceLabel(1);
        if (st == null) st="";
        tmp1 = st.indexOf("<track\t");
        if (tmp1 != -1) {
            tmp2 = st.indexOf("track>");
            st = st.substring(tmp1 + 7,tmp2);
        } // if

        int cc = 0;
        int pos = -1;
        while ( (pos = st.indexOf("\t",pos+1)) != -1) {
            if (cc % 2 == 0) {
                titre += "\tx"+ cc/2;
            } else {
                titre += "\ty"+ cc/2;
            }
            cc++;
        }

        TextWindow tw = new TextWindow("Track "+ imp.getShortTitle(), titre, "", 450,450);

        tw.setFont(new Font("Monospaced", Font.PLAIN, 12));
        for(int j=1;j<=nFrames;j++){
        st = is.getSliceLabel(j);
        if (st == null) st="";
            tmp1 = st.indexOf("<track\t");
            if (tmp1 != -1) {
                tmp2 = st.indexOf("track>");
                st = st.substring(tmp1 + 7,tmp2);
            } // if
            tw.append(j+"\t"+ st);
        } // for j		
    } // public void run(ImageProcessor ip)

    void showAbout() {
        IJ.showMessage("About DrawCentri_...",
            "Ce PlugIn sert à sortir dans une fenêtre texte\n"
            +" les différentes position des centrioles.");
    }
}// class TextCentri